<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HomeController;

// Public Routes
Route::post('/registerpartner', [UserController::class, 'registerPartner']);
Route::post('/registerCustomer', [UserController::class, 'registerCustomer']);
Route::post('/loginmaster', [UserController::class, 'loginmaster']);
Route::post('/loginpartner', [UserController::class, 'loginpartner']);
Route::post('/loginAgent', [UserController::class, 'loginAgent']);
Route::post('/addfeedback', [HomeController::class, 'addfeedback']);
Route::post('/addlead', [HomeController::class, 'addlead']);
Route::post('/addqr', [UserController::class, 'generateQR']);
Route::get('/qr', [UserController::class, 'getAllQr']);
Route::delete('/qr/{id}', [UserController::class, 'destroyQr']);
Route::get('/customers/{id}', [UserController::class, 'getCustomerById']);
Route::get('/download', [UserController::class, 'generateQrCode']);
Route::get('/getallreview/{id}', [UserController::class, 'getAllReview']);


// Protected Routes
Route::middleware(['auth:sanctum'])->group(function(){
    Route::post('/logout', [UserController::class, 'logout']);
    Route::get('/loggeduser', [UserController::class, 'logged_user']);
    Route::get('/partner', [UserController::class, 'getAllPartner']);
    Route::get('/feedback', [HomeController::class, 'getAllMasterFeedback']);
    Route::get('/lead', [HomeController::class, 'getAllLead']);
    Route::post('/partnerfeedback', [UserController::class, 'getAllPartnerFeedback']);
    Route::post('/customerfeedback', [UserController::class, 'getAllCustomerFeedback']);
    Route::get('/customer', [UserController::class, 'getAllCustomer']);
    Route::post('/feedback', [UserController::class, 'getAllFeedback']);
    Route::delete('/user/{id}', [UserController::class, 'destroyUser']);
    Route::delete('/customer/{id}', [UserController::class, 'destroyCustomer']);
    Route::post('/changepassword', [UserController::class, 'change_password']);
    Route::post('/changepasswordAgent', [UserController::class, 'change_passwordAgent']);
    Route::post('/updateUser', [UserController::class, 'updateUser']);
    Route::post('/updateCustomer', [UserController::class, 'updateCustomer']);
    Route::post('/addreview', [UserController::class, 'addReview']);
    Route::get('/getreview', [UserController::class, 'getReview']);
    Route::post('/ch-password', [UserController::class, 'changePassword']);
   
    Route::delete('/deletereview/{id}', [UserController::class, 'delReview']);
});