<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Customer;
use App\Models\Feedback;
use App\Models\Generate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Response;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\CustomReview;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function registerPartner(Request $request){
        $apikey = Str::random(32);
        $request->validate([
            'firstname'=>'required',
            'lastname'=>'required',
            'mobile'=>'required',
            'email'=>'required|email',
            'password'=>'required|confirmed',
            'site_url'=>'required',
            'role'=>'required'
        ]);
        $pimage = $request->file('pimage')->store('pimages', 'public');
        if(User::where('email', $request->email)->first()){
            return response([
                'message' => 'Email already exists',
                'status'=>'failed'
            ], 200);
        }

        $user = User::create([
            'firstname'=>$request->firstname,
            'lastname'=>$request->lastname,
            'mobile'=>$request->mobile,
            'email'=>$request->email,
            'country'=>$request->country,
            'state'=>$request->state,
            'city'=>$request->city,
            'address'=>$request->address,
            'site_url'=>$request->site_url,
            'agency_pan'=>$request->agency_pan,
            'agency_name'=>$request->agency_name,
            'role'=>$request->role,
            'agency_logo'=>$pimage,
            'apikey' => $apikey,  // Generates a 32-character API key
            'password'=>Hash::make($request->password),
            'status'=>json_decode($request->status),
        ]);
        // Mail::to($request->email)->send(new TestMail());
        return response([
            'token'=>$apikey,
            'message' => 'Registration Success',
            'status'=>'success'
        ], 201);
    }
    public function registerCustomer(Request $request)
    {
        $apiKey = $request->api_key; 
        
        // Validate request data
        $request->validate([
            'firstname' => 'required',
            'lastname'  => 'required',
            'mobile'    => 'required',
            'email'     => 'required|email',
            'password'  => 'required|confirmed',
        ]);
    
        // Check if the email already exists
        if (Customer::where('email', $request->email)->first()) {
            return response([
                'message' => 'Email already exists',
                'status'  => 'failed'
            ], 200);
        }
    
        // Create a new customer
        $user = Customer::create([
            'firstname'    => $request->firstname,
            'lastname'     => $request->lastname,
            'mobile'       => $request->mobile,
            'email'        => $request->email,
            'country'      => $request->country,
            'state'        => $request->state,
            'city'         => $request->city,
            'address'      => $request->address,
            'apikey'       => $apiKey,
            'url'          => $request->url,
            'agency_name'  => $request->agency_name,
            'agency_pan'   => "$request->agency_pan",
            'password'     => Hash::make($request->password),
            'status'       => json_decode($request->status),
        ]);
    
        // Generate the QR code with customer details
        $qrcodeContent = "https://alphareview.in/review/" . urlencode($user->id) . "/" . urlencode($user->agency_name);
        // $fileName = "qrcodes{$user->id}_{$user->agency_name}.png";
        // $filePath = storage_path('app/public/' . $fileName);
        // QrCode::format('png')
        // ->size(500)
        // ->errorCorrection('H')
        // ->generate($qrcodeContent, $filePath);

    // Make the file publicly accessible
        // $fileUrl = asset('storage/' . $fileName);
        // $qrcode = QrCode::size(500)->format('svg')->errorCorrection('H')
        //         ->backgroundColor(255, 255, 255)
        //         ->color(0, 0, 0)->generate($qrcodeContent);
        // $base64 = base64_encode($qrcode);
    
        // Update the customer record with the generated QR code
        $user->update([
            'qrcode' => $qrcodeContent
        ]);
    
        // Return the response
        return response([
            'token'   => $apiKey,
            'message' => 'Registration Success',
            'status'  => 'success'
        ], 201);
    }
    
    public function changePassword(Request $request)
    {
       
        $request->validate([
            'email' => 'required|email|exists:customers,email',
            'password' => 'required|confirmed|min:6',
        ]);
    
        // Find the customer by email
        $customer = Customer::where('email', $request->email)->first();
    
        if (!$customer) {
            return response()->json([
                'status' => 'failed',
                'message' => 'Customer not found',
            ], 404);
        }
    
     
        $customer->password = Hash::make($request->password);
        $customer->save();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Password updated successfully',
        ], 200);
    }

    public function loginmaster(Request $request){
        $request->validate([
            'email'=>'required|email',
            'password'=>'required',
        ]);
        $user = User::where('email', $request->email)->where('role', 'master')->first();
        if($user && Hash::check($request->password, $user->password)){
            $token = $user->createToken($request->email)->plainTextToken;
            return response([
                'token'=>$token,
                'message' => 'Login Success',
                'status'=>'success',
                'result'=>$user
            ], 200);
        }
        return response([
            'message' => 'The Provided Credentials are incorrect',
            'status'=>'failed'
        ], 401);
    }
    public function loginpartner(Request $request){
        $request->validate([
            'email'=>'required|email',
            'password'=>'required',
        ]);
        $user = User::where('email', $request->email)->where('role', 'partner')->first();
        if($user && Hash::check($request->password, $user->password)){
            $token = $user->createToken($request->email)->plainTextToken;
            return response([
                'token'=>$token,
                'message' => 'Login Success',
                'status'=>'success',
                'result'=>$user
            ], 200);
        }
        return response([
            'message' => 'The Provided Credentials are incorrect',
            'status'=>'failed'
        ], 401);
    }
    public function loginAgent(Request $request){
        $request->validate([
            'email'=>'required|email',
            'password'=>'required',
        ]);
        $user = Customer::where('email', $request->email)->first();
        if($user && Hash::check($request->password, $user->password)){
            $token = $user->createToken($request->email)->plainTextToken;
            return response([
                'token'=>$token,
                'message' => 'Login Success',
                'status'=>'success',
                'result'=>$user
            ], 200);
        }
        return response([
            'message' => 'The Provided Credentials are incorrect',
            'status'=>'failed'
        ], 401);
    }
    public function getAllPartner()
    {
        $users = User::orderBy('id', 'DESC')->get();
        foreach($users as $user){
            $url = Storage::url($user->agency_logo);
            $user->imgpath = 'https://api.alphareview.in'.''.$url;
        }
        return response([
            'result'=>$users
        ], 200);
        // Retrieve all users from the users table
        // $users = User::all();
    
        // // Return the users as a JSON response
        // return response()->json([
        //     'result' => $users,
        //     'message' => 'All users retrieved successfully',
        //     'status' => 'success'
        // ], 200);
    }
    public function getAllPartnerFeedback(Request $request)
     {
        $apiKey = $request->header('api_key'); 
        $feedback = Feedback::where('api_key', $request->apikey)->get();
        // Return the users as a JSON response
        return response()->json([
            'result' => $feedback,
            'message' => 'All Feedback retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    public function getAllCustomerFeedback(Request $request)
     {
        // $apiKey = $request->header('api_key'); 
        $feedback = Feedback::where('api_key', $request->apikey)->get();
        return response()->json([
            'result' => $feedback,
            'message' => 'All Feedback retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    
    public function getAllCustomer(Request $request)
    {
        $user = Auth::user();

        if(!$user){
            return response()->json([
                'result' => $user,
                'message' => 'Unauthrized',
                'status' => 'false'
            ], 200);
        }
        $users = Customer::all();;
    
        return response()->json([
            'result' => $users,
            'message' => 'All users retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    public function getCustomerById($id)
    {
        // Retrieve the customer with the given ID from the customers table
        $customer = Customer::find($id);
    
        // Check if the customer exists
        if ($customer) {
            // Return the customer as a JSON response
            return response()->json([
                'result' => $customer,
                'message' => 'Customer retrieved successfully',
                'status' => 'success'
            ], 200);
        } else {
            // Return an error response if the customer is not found
            return response()->json([
                'message' => 'Customer not found',
                'status' => 'error'
            ], 404);
        }
    }

     public function getAllFeedback()
    {
        // Retrieve all users from the users table
        $users = Feedback::all();
    
        // Return the users as a JSON response
        return response()->json([
            'result' => $users,
            'message' => 'All users retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    public function loginR(Request $request){
        // Validate the input
    $request->validate([
        'email' => 'required|email',
        'password' => 'required',
    ]);

    // Retrieve the user with the specified email and role (customer or member)
    $user = User::where('email', $request->email)
                ->whereIn('role', ['customer', 'member'])
                ->first();

    // Check if the user exists and the password is correct
    if ($user && Hash::check($request->password, $user->password)) {
        // Generate a token for the user
        $token = $user->createToken($request->email)->plainTextToken;
        
        return response()->json([
            'token' => $token,
            'message' => 'Login Success',
            'status' => 'success',
            'result' => $user, // Adjust this if you want to limit user details
        ], 200);
    }

    // Return an error response if credentials are incorrect
    return response()->json([
        'message' => 'The provided credentials are incorrect',
        'status' => 'failed',
    ], 401);
    }

    public function logout(){
        auth()->user()->tokens()->delete();
        return response([
            'message' => 'Logout Success',
            'status'=>'success'
        ], 200);
    }
    
    public function logged_user(){
        $loggeduser = auth()->user();
        return response([
            'user'=>$loggeduser,
            'message' => 'Logged User Data',
            'status'=>'success'
        ], 200);
    }

    public function change_password(Request $request){
        $request->validate([
            'password' => 'required|confirmed',
        ]);
        $loggeduser = auth()->user();
        $loggeduser->password = Hash::make($request->password);
        $loggeduser->save();
        return response([
            'message' => 'Password Changed Successfully',
            'status'=>'success'
        ], 200);
    }
    public function change_passwordAgent(Request $request){
        $request->validate([
            'password' => 'required|confirmed',
        ]);
        $user = Customer::findOrFail($request->id);
        $user->password = Hash::make($request->password);
        $user->save();
        return response([
            'message' => 'Password Changed Successfully',
            'status'=>'success'
        ], 200);
    }
    public function getAllUsersApikey(Request $request)
    {
         $apiKey = $request->header('api_key');  // Assuming the API key is passed in the headers
         $users = User::where('apikey', $apiKey)->where('role', 'childCustomer')->get();
        // Retrieve all users from the users table
        // $users = User::all();
    
        // Return the users as a JSON response
        return response()->json([
            'result' => $users,
            'message' => 'All users retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    public function destroyUser($id)
    {
        $user = User::find($id)->delete();
        return response([
                'message'=>'User Delete  Successfully',
                'status'=>'success'
        ], 200);
    } 
    public function destroyCustomer($id)
    {
        $user = Customer::find($id)->delete();
        return response([
                'message'=>'Customer Delete  Successfully',
                'status'=>'success'
        ], 200);
    } 
    public function updateUser(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'id' => 'required|exists:users,id',
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'phone' => 'nullable|string|max:15', // You can customize this
            'email' => 'required|email|max:255|unique:users,email,' . $request->id,
        ]);

        // Find the user by id or fail if not found
        $user = User::findOrFail($request->id);

        // Update user details
        $user->firstname = $request->firstname;
        $user->lastname = $request->lastname;
        $user->mobile = $request->mobile;
        $user->email = $request->email;
        $user->city = $request->city;
        $user->state = $request->state;
        $user->country = $request->country;
        $user->address = $request->address;
        $user->site_url = $request->site_url;
        $user->agency_name = $request->agency_name;
        $user->agency_pan = $request->agency_pan;
        $user->save();

        // Return the response
        return response()->json([
            'result' => $user,
            'message' => 'User updated successfully',
            'status' => 'success',
            'token' => $request->token
        ], 200);
    }
    public function updateCustomer(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            // 'id' => 'required|exists:users,id',
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'phone' => 'nullable|string|max:15', // You can customize this
            // 'email' => 'required|email|max:255|unique:users,email,' . $request->id,
        ]);

        // Find the user by id or fail if not found
        $user = Customer::findOrFail($request->id);

        // Update user details
        $user->firstname = $request->firstname;
        $user->lastname = $request->lastname;
        $user->mobile = $request->mobile;
        $user->email = $request->email;
        $user->city = $request->city;
        $user->state = $request->state;
        $user->country = $request->country;
        $user->address = $request->address;
        $user->url = $request->url;
        $user->agency_name = $request->agency_name;
        $user->agency_pan = $request->agency_pan;
        $user->save();

        // Return the response
        return response()->json([
            'result' => $user,
            'message' => 'Customer updated successfully',
            'status' => 'success',
            'token' => $request->token
        ], 200);
    }
    //  public function updateUser(Request $request)
    // {
    //     // Validate the incoming request data
    //     $validatedData = $request->validate([
    //         'id' => 'required|exists:users,id',
    //         'firstname' => 'required|string|max:255',
    //         'lastname' => 'required|string|max:255',
    //         'phone' => 'nullable|string|max:15', // You can customize this
    //         'email' => 'required|email|max:255|unique:users,email,' . $request->id,
    //     ]);

    //     // Find the user by id or fail if not found
    //     $user = User::findOrFail($request->id);

    //     // Update user details
    //     $user->firstname = $request->firstname;
    //     $user->lastname = $request->lastname;
    //     $user->mobile = $request->mobile;
    //     $user->email = $request->email;
    //     $user->city = $request->city;
    //     $user->state = $request->state;
    //     $user->country = $request->country;
    //     $user->address = $request->address;
    //     $user->url = $request->site_url;
    //     $user->agency_name = $request->agency_name;
    //     $user->agency_pan = $request->agency_pan;
    //     $user->save();

    //     // Return the response
    //     return response()->json([
    //         'result' => $user,
    //         'message' => 'User updated successfully',
    //         'status' => 'success',
    //         'token' => $request->token
    //     ], 200);
    // }
     public function loginmemberchild(Request $request){
        $apiKey = $request->header('api_key'); 
        $request->validate([
            'email'=>'required|email',
            'password'=>'required',
        ]);
        $user = User::where('email', $request->email)->where('role', 'childCustomer')->where('apikey', $apiKey)->first();
        if($user && Hash::check($request->password, $user->password)){
            $token = $user->createToken($request->email)->plainTextToken;
            return response([
                'token'=>$token,
                'message' => 'Login Success',
                'status'=>'success',
                'result'=>$user
            ], 200);
        }
        return response([
            'message' => 'The Provided Credentials are incorrect',
            'status'=>'failed'
        ], 401);
    }
    
    public function registerChildCustomer(Request $request){
        $request->validate([
            'firstname'=>'required',
            'lastname'=>'required',
            'phone'=>'required',
            'email'=>'required|email',
            'password'=>'required|confirmed',
            'status'=>'required',
            'apikey'=>'required'
        ]);
        if(User::where('email', $request->email)->first()){
            return response([
                'message' => 'Email already exists',
                'status'=>'failed'
            ], 200);
        }

        $user = User::create([
            'firstname'=>$request->firstname,
            'lastname'=>$request->lastname,
            'phone'=>$request->phone,
            'email'=>$request->email,
            'role'=>'childCustomer',
            'apikey'=>$request->apikey,
            'password'=>Hash::make($request->password),
            'status'=>json_decode($request->status),
        ]);
        $token = $user->createToken($request->email)->plainTextToken;
        return response([
            'token'=>$token,
            'message' => 'Registration Success',
            'status'=>'success'
        ], 201);
    }
    public function loginChildCustomer(Request $request){
        $apiKey = $request->header('api_key'); 
        $request->validate([
            'email'=>'required|email',
            'password'=>'required',
        ]);
        $user = User::where('email', $request->email)->where('role', 'childCustomer')->where('apikey', $apiKey)->first();
        if($user && Hash::check($request->password, $user->password)){
            $token = $user->createToken($request->email)->plainTextToken;
            return response([
                'token'=>$token,
                'message' => 'Login Success',
                'status'=>'success',
                'result'=>$user
            ], 200);
        }
        return response([
            'message' => 'The Provided Credentials are incorrect',
            'status'=>'failed'
        ], 401);
    }
    // public function generateQR(Request $request){
    //     $apiKey = $request->api_key; 
    //     $request->validate([
    //         'url'=>'required',
    //     ]);
    //     $qrcode = QrCode::size(200)->generate($request->url);
    //     $base64 = base64_encode($qrcode);
    //     $user = Generate::create([
    //         'apikey'=>$apiKey,
    //         'qrcode'=>$base64,
    //         'url'=> $request->url,
    //     ]);
    //     return response([
    //         'token'=>$apiKey,
    //         'message' => 'QR Geneate Success',
    //         'status'=>'success'
    //     ], 201);
    // }
  
    public function generateQR(Request $request)
    {
        $apiKey = $request->api_key;
    
        // Validate input
        $request->validate([
            'url' => 'required|url',
        ]);
    
        // Generate a unique filename
        $fileName = 'qr_' . Str::random(10) . '.svg';
        $filePath = 'uploads/qrcodes/' . $fileName;
    
        // Ensure the directory exists
        if (!file_exists(public_path('uploads/qrcodes'))) {
            mkdir(public_path('uploads/qrcodes'), 0755, true);
        }
    
        // Generate QR and save as SVG file
        $qrContent = QrCode::size(200)->format('svg')->generate($request->url);
        file_put_contents(public_path($filePath), $qrContent);
    
        // Save record to database
        $user = Generate::create([
            'apikey' => $apiKey,
            'qrcode' => $filePath,
            'url' => $request->url,
            'user_id' => $request->user_id
        ]);
    
        return response()->json([
            'message' => 'QR code generated successfully.',
            'qrcode_path' => asset($filePath), // Public URL to QR
            'data' => $user
        ]);
    }


    

    public function getAllQr()
    {
        // Retrieve all users from the users table
        $users = Generate::all();
    
        // Return the users as a JSON response
        return response()->json([
            'result' => $users,
            'message' => 'All QR retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    public function destroyQr($id)
    {
        $user = Generate::find($id)->delete();
        return response([
                'message'=>'QR Delete  Successfully',
                'status'=>'success'
        ], 200);
    } 
     public function downloadQRCode()
    {
        // Generate the QR code URL using the API
        $qrCodeUrl = "https://api.qrserver.com/v1/create-qr-code/?data=https://reviewcardmaker.com&size=200x200";

        // Fetch the image from the QR code API
        $qrCodeImage = Http::get($qrCodeUrl);

        // Check if the request was successful
        if ($qrCodeImage->successful()) {
            // Get the content of the image
            $imageContent = $qrCodeImage->body();

            // Set the response to return the image as a downloadable file
            return Response::make($imageContent, 200, [
                'Content-Type' => 'image/png',
                'Content-Disposition' => 'attachment; filename="qr_code.png"',
            ]);
        } else {
            // Handle any errors (e.g., API not responding)
            return response()->json(['error' => 'Failed to generate QR code'], 500);
        }
    }
    public function generateQrCode()
{
    // The URL to encode in the QR code
    $qrcodeContent = "https://api.alphareview.in/review/";

    // Generate the QR code as an image file (e.g., PNG)
    $fileName = "qrcodes.png";
    $filePath = storage_path('app/public/' . $fileName);

    // Create QR code and save to file
    QrCode::format('png')
    ->size(500)
    ->errorCorrection('H')
    ->generate($qrcodeContent, $filePath);

    // Make the file publicly accessible
    $fileUrl = asset('storage/' . $fileName);

    // Return the file URL
    return response()->json([
        'success' => true,
        'url' => $fileUrl,
    ]);
}

public function addReview(Request $request)
{
   
    $request->validate([
        'custom_review' => 'required|string|max:1000',
    ]);

    $review = CustomReview::create([
        'customer_id' =>$request->customer_id,
        'custom_review' => $request->custom_review,
    ]);

    return response()->json([
        'message' => 'Review submitted.',
        'review' => $review,
    ]);
}

    public function getReview()
    {
        // Get the currently authenticated user
        $user = Auth::user();

        // Optional: If you want only reviews by the logged-in user
        $reviews = CustomReview::where('customer_id', $user->id)->get();

        return response()->json([
            'result' => $reviews,
            'message' => 'Reviews retrieved successfully',
            'status' => 'success',
        ], 200);
    }

    public function delReview($id)
    {
        $user = Auth::user();

        // Find the review
        $review = CustomReview::find($id);

        // Check if review exists
        if (!$review) {
            return response()->json([
                'message' => 'Review not found',
                'status' => 'error',
            ], 404);
        }

        // Optional: Check if the authenticated user is the owner of the review
        if ($review->customer_id !== $user->id) {
            return response()->json([
                'message' => 'Unauthorized to delete this review',
                'status' => 'error',
            ], 403);
        }

        // Delete the review
        $review->delete();

        return response()->json([
            'message' => 'Review deleted successfully',
            'status' => 'success',
        ], 200);
    }


    public function getAllReview($id)
    {
       
        $reviews = CustomReview::where('customer_id', $id)->get();

        return response()->json([
            'result' => $reviews,
            'message' => 'Reviews retrieved successfully',
            'status' => 'success',
        ], 200);
    }

}
