<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\User;
use App\Models\Feedback;
use App\Models\Customer;
use App\Models\Lead;

  

class HomeController extends Controller
{
    public function addfeedback(Request $request){
        // $apiKey = $request->header('api_key'); 
        $user = Customer::where('id', $request->cust_id)->first();
        $request->validate([
            'name'=>'required',
            'phone'=>'required',
            'email'=>'required|email',
            'desc'=>'required',
        ]);
        $user = Feedback::create([
            'name'=>$request->name,
            'phone'=>$request->phone,
            'email'=>$request->email,
            'cust_id'=>$request->cust_id,
            'api_key'=>$request->api_key,
            'desc'=>$request->desc,
        ]);
        // // Mail::to($request->email)->send(new TestMail());
        return response([
            'token'=>$user['id'],
            'message' => 'Feedback Save Success',
            'status'=>'success'
        ], 201);
    }
    public function getAllMasterFeedback()
    {
        // Retrieve all users from the users table
        $users = Feedback::all();
    
        // Return the users as a JSON response
        return response()->json([
            'result' => $users,
            'message' => 'All Feedback retrieved successfully',
            'status' => 'success'
        ], 200);
    }
    public function addlead(Request $request){
        $request->validate([
            'name'=>'required',
            'phone'=>'required',
            'email'=>'required|email',
        ]);
        $user = Lead::create([
            'name'=>$request->name,
            'phone'=>$request->phone,
            'email'=>$request->email,
            'city'=>$request->city,
            'state'=>$request->state,
        ]);
        return response([
            'result'=>$user,
            'message' => 'lead Save Success',
            'status'=>'success'
        ], 201);
    }
    public function getAllLead()
    {
        // Retrieve all users from the users table
        $users = Lead::all();
    
        // Return the users as a JSON response
        return response()->json([
            'result' => $users,
            'message' => 'All Lead retrieved successfully',
            'status' => 'success'
        ], 200);
    }
}
